/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist;

import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.contentassist.model.ValueElement;
import com.aptana.parsing.lexer.IRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;

public class HTMLAttributeValueProposal
extends CommonCompletionProposal {
    private static final Image ATTRIBUTE_ICON = HTMLPlugin.getImage("/icons/attribute.png");

    public HTMLAttributeValueProposal(ValueElement value, IRange range, Image[] userAgents) {
        super(value.getName(), range.getStartingOffset(), range.getLength(), value.getName().length(), ATTRIBUTE_ICON, value.getName(), null, value.getDescription());
        this.setFileLocation("HTML Core");
        this.setUserAgentImages(userAgents);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        try {
            IDocument document = viewer.getDocument();
            int prevChar = this._replacementOffset > 0 ? (int)document.getChar(this._replacementOffset - 1) : 32;
            char quote = '\"';
            switch (prevChar) {
                case 39: {
                    quote = '\'';
                    break;
                }
                case 34: {
                    break;
                }
                default: {
                    this._replacementString = "\"" + this._replacementString;
                    ++this._cursorPosition;
                }
            }
            int nextCharIndex = this._replacementOffset + this._replacementLength;
            if (nextCharIndex >= document.getLength()) {
                this._replacementString = String.valueOf(this._replacementString) + quote;
                ++this._cursorPosition;
            } else {
                char nextChar = document.getChar(nextCharIndex);
                switch (nextChar) {
                    case '\"': 
                    case '\'': {
                        break;
                    }
                    case '\t': 
                    case ' ': 
                    case '/': 
                    case '>': {
                        this._replacementString = String.valueOf(this._replacementString) + quote;
                        ++this._cursorPosition;
                        break;
                    }
                    default: {
                        this._replacementString = String.valueOf(this._replacementString) + quote + " ";
                        this._cursorPosition += 2;
                        break;
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        super.apply(viewer, trigger, stateMask, offset);
    }
}

